#version 330
#extension GL_EXT_gpu_shader4 : enable
// shiny quadtree truchetMod01.fsh  by  abje

//https://www.shadertoy.com/view/ws2SWD
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177 //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//some function
#define rot(spin) mat2(cos(spin),sin(spin),-sin(spin),cos(spin))

//some macros
#define subs 0.4
#define limit 4.0

#define STEPS 100
#define FAR 20.0

//some constant macros
#define HASHSCALE3 vec3(.6531, .5563, .7498)

//hash function in hash without sine by Dave_Hoskins
//https://www.shadertoy.com/view/4djSRW
//it seems to make a weird truchet pattern
float hash13(vec3 p3)
{
	p3  = fract(p3 * HASHSCALE3);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z*15.3023+0.434);
}

#define checktree(i)                        \
for (j = 0.0; j < i; j++) {             \
    vec2 h = floor(r*exp2(j))*exp2(-j); \
    float rand = hash13(vec3(h,int(j)));\
    if (rand >= subs) {                 \
        break;                          \
    }                                   \
}

float truchet(vec2 p, int type) {
    float len;
    if (type == 0)
    {
        p = p+step(p.x+p.y,0.0)-0.5;
        len = abs(length(p)-0.5)-0.1667;
    }
    else if (type == 1)
    {
        len = -length(abs(p)-0.5)+0.3333;
    }
    else if (type == 2)
    {
        vec2 dir;
        if (abs(p.x) > abs(p.y)) {
            dir = vec2(sign(p.x),0.0);
        } else {
            dir = vec2(0.0,sign(p.y));
        }
        len = abs(length(p-dir*0.5))-0.1667;
    }
    else if (type == 3)
    {
        vec2 dir;
        if (abs(p.x) > abs(p.y)) {
            dir = vec2(sign(p.x),0.0);
        } else {
            dir = vec2(0.0,sign(p.y));
        }
        len = min(abs(length(p-0.5)-0.5),abs(length(p-dir*0.5)))-0.1667;
    }
    else if (type == 4)
    {
        p = abs(p)-0.1667;

        len = -length(min(p,0.0))+max(min(p.x,p.y),0.0);
    }
    else if (type == 5)
    {
        p.y = abs(p.y);

        len = min(p.y,length(p-vec2(0,0.5)))-0.1667;
    }
    else if (type == 6)
    {
        p.x = abs(p.x);
        len = min(max(-p.y-0.1667,-length(p-0.5)+0.3333),length(p+vec2(0,0.5))-0.1667);      
    }
    return len;
}

float quadtruchet(vec2 p) {
    float len = 0.0;
    
    float j;
    vec2 r = p;
    checktree(limit);
    float i = j;
    
    //the position in the bottom left corner of the truchet cell
    vec2 fp = floor(p*exp2(i))*exp2(-i);

    //the local position on the truchet cell (always 0-1)
    vec2 lp = (p-fp)*exp2(i);
    
    float rand = fract(hash13(vec3(fp,-i))*10.0);
    vec2 q = lp-0.5;

    int celltype = int(rand*7.0);
    int rots = int(fract(rand*7.0)*4.0);

    for (int i = 0; i < rots; i++) {
        q = vec2(q.y,-q.x);
    }
    
    float l = truchet(q,celltype);
    
    len = l*exp2(-i)*(1.0-mod(i,2.0)*2.0);
    //len = l*exp2(-i);
    
    for (float i = 1.0; i <= limit; i++) {
        
        if (i <= j) continue;
        
        //the position in the bottom left corner of the truchet cell
        fp = floor(p*exp2(i))*exp2(-i);
		
        //the local position on the truchet cell (always 0-1)
        lp = (p-fp)*exp2(i);

        //check for the overlapping black dots
        vec2 p2 = p*exp2(i);
        vec2 fp2 = floor(p2-0.5);
        for(int x = -0; x <= 1; x++) {
            for(int y = -0; y <= 1; y++) {
                r = (fp2+vec2(x,y))*exp2(-i);
                //this branch doesn't do anything, but it skips the random() once
                if (r != fp)
                {
                    checktree(i);

                    if (i==j) {
                        float l = length(abs(p2-fp2-vec2(x,y)-0.5)-0.5)-0.3333;
                        float s = mod(i,2.0)*2.0-1.0;
                        len = min(l*exp2(-i),len*s)*s;
                    }
                }
            }
        }
	}
    return len;
}

float map(vec3 p) {
    vec2 q = vec2(p.y+0.02,quadtruchet(p.xz)+0.02);
    q.y = -(length(max(q,vec2(0.0)))+min(max(q.x,q.y),0.0)-0.06);
    q.x = -p.y-0.05;
    return -(length(max(q,vec2(0.0)))+min(max(q.x,q.y),0.0)-0.04);
}

vec3 findnormal(vec3 p, float len, float d) {
    vec2 eps = vec2(d/iResolution.y*2.0,0.0);
    
    return normalize(vec3(
        len-map(p-eps.xyy),
        len-map(p-eps.yxy),
        len-map(p-eps.yyx)));
}

// Tri-Planar blending function. Based on an old Nvidia writeup:
// GPU Gems 3 - Ryan Geiss: https://developer.nvidia.com/gpugems/GPUGems3/gpugems3_ch01.html
vec3 tex3D(sampler2D t, in vec3 p, in vec3 n ){
    
    n = max(abs(n), 0.001);
    n /= dot(n, vec3(1));
    mat3 tex = mat3(
        texture2D(t, p.yz).xyz,
        texture2D(t, p.zx).xyz,
        texture2D(t, p.xy).xyz);
    
    tex = matrixCompMult(tex,tex);
    
    return tex*n;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = (gl_FragCoord.xy*2.0-iResolution.xy)/iResolution.y;
    
    vec3 ro = vec3(0.5,0.4,iTime);
    vec3 rd = normalize(vec3(uv,1));
    
    if (length(iMouse.xy) > 40.0) {
    	rd.yz *= rot(iMouse.y/iResolution.y*3.14-3.14*0.5);
    	rd.xz *= rot(iMouse.x/iResolution.x*3.14*2.0-3.14);
    }
    
    float d = 0.0;
    float l;
    for (int i = 0; i < STEPS; i++) {
        l = map(ro+rd*d);
        
        if (l < d/iResolution.y*2.0 || d > FAR) break;
        
        d += l;
    }
    
    vec3 col = vec3(0);
    
    vec3 sky = vec3(0.1,0.3,0.4)+(rd*0.07);
    
    if (d < FAR) {
        vec3 p = ro+rd*d;
        vec3 n = findnormal(p, l, d);
        
        vec3 tex = tex3D(iChannel0,p*5.0,n);
        
        float light = max(dot(n,normalize(vec3(1))),0.1);
        
        col = tex*light;
        
        rd = reflect(rd,n);
        
        float sun = max(dot(rd,normalize(vec3(1))),0.0);
        vec3 suncol = vec3(1.4,2.0,0.0);
        sun = pow(sun,1000.0);
        
        col += sun*suncol*0.8;
        
        float dist = d/FAR;
        col = mix(col,sky,dist*dist);
    } else {
        float sun = max(dot(rd,normalize(vec3(1))),0.0);
        sun = pow(sun,1000.0);
        vec3 suncol = vec3(1.4,2.0,0.0);
        col = mix(sky,suncol,sun);
    }
    
    gl_FragColor = vec4(sqrt(col),1);
    
}